#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include <windows.h>
#include <tchar.h>
#if defined(_UNICODE) && !defined(UNICODE)
#define UNICODE
#endif

int ToOEMCodePage(LPCTSTR lpStr, LPSTR lpOemStr, int cbOem)
{
#ifdef UNICODE
    return WideCharToMultiByte(CP_OEMCP, 0, lpStr, -1, lpOemStr, cbOem, NULL, NULL);
#else
    DWORD dstLen;
    dstLen = strlen(lpStr);
    if (dstLen >= cbOem) dstLen = cbOem - 1;
    ZeroMemory(lpOemStr, (size_t) cbOem);
    return CharToOemBuff(lpStr, lpOemStr, dstLen);
#endif
}

#define HWNDLIST_BLOCKSIZE 16
HWND *hWndList;
int hWndListLen;
int hWndListAllocBlocks;

/* WinAPI prototype:
 * BOOL CALLBACK EnumWindowsProc(_In_ HWND hwnd, _In_  LPARAM lParam); */
BOOL CALLBACK PrintAndAddToList(HWND hWnd, LPARAM onlyVisible)
{
    TCHAR winTitle[80];
    CHAR winTitleOem[80];
    BOOL visible;
    visible = IsWindowVisible(hWnd);
    /* Do not enumerate windows we can't get a title for (and that are invisible, if onlyVisible is set) */
    if((!onlyVisible || visible) && GetWindowText(hWnd, winTitle, 80)) {
        /* It's alright if we can't convert it to OEM code page, though */
        if (!ToOEMCodePage(winTitle, winTitleOem, 80)) {
            strcpy(winTitleOem, "?");
        }
        printf("%5d %-65.65s %s\n", hWndListLen + 1, winTitleOem,
          visible ? "Yes" : "No");
        if (hWndListLen >= HWNDLIST_BLOCKSIZE * hWndListAllocBlocks) {
            hWndListAllocBlocks++;
            hWndList = (HWND*) realloc(hWndList, sizeof(HWND*) * HWNDLIST_BLOCKSIZE * hWndListAllocBlocks);
            /* only signal failure if out of memory */
            if (!hWndList) {
                return FALSE;
            }
        }
        hWndList[hWndListLen++] = hWnd;
    }
    return TRUE;
}

void usage(const char *progname)
{
    printf("Interactive tool for toggling a window's visibility.\n\n"
      "%s [/V]\n\n"
      "  /V         Only show visible windows.\n",
      progname);
}

void cleanup(void)
{
    if (hWndList) {
        hWndListLen = 0;
        hWndListAllocBlocks = 0;
        free(hWndList);
        hWndList = NULL;
    }
}

int main(int argc, char **argv)
{
    int winNum, newState, ret;
    LPARAM onlyVisible;

    hWndList = NULL;
    hWndListLen = 0;
    hWndListAllocBlocks = 0;

    winNum = 0;
    onlyVisible = FALSE;

    if (argc == 2) {
        if (strlen(argv[1]) == 2 && argv[1][1] == '?') {
            usage(argv[0]);
            return 0;
        } else if (strlen(argv[1]) >= 2 && tolower(argv[1][1]) == 'v') {
            onlyVisible = TRUE;
        } else {
            usage(argv[0]);
            return 1;
        }
    } else if (argc > 2) {
        usage(argv[0]);
        return 1;
    }

    printf("%-72s%s\n", "WinNo Window Title", "Visible");

    if (!EnumWindows(PrintAndAddToList, onlyVisible)) {
        /* TODO: Print reasonable error message */
        cleanup();
        return 1;
    }
    printf("\nNumber of window to toggle [1-%d]: ", hWndListLen);
    if (scanf("%d\n", &winNum) && winNum >= 1 && winNum <= hWndListLen) {
        newState = IsWindowVisible(hWndList[winNum-1]) ? SW_HIDE : SW_SHOW;
        ShowWindow(hWndList[winNum-1], newState);
        ret = 0;
    } else {
        fputs("Invalid input!", stderr);
        ret = 1;
    }
    cleanup();
    return ret;
}
